#include <iostream>

#include "even_num.h"
#include "even_num_exception.h"

using namespace std;

ostream &operator <<(std::ostream &os, const Even_Num &even_num) {
	os << even_num.val;
	return os;
}

Even_Num operator +(const Even_Num &lhs, const Even_Num &rhs) {
	Even_Num result = lhs;
	return result += rhs;
}

Even_Num operator /(const Even_Num &lhs, const Even_Num &rhs) {
	Even_Num result = lhs;
	return result /= rhs;
}

Even_Num::Even_Num(int val) : val(val) {
	if (val % 2 == 1) throw Even_Num_Exception("attempt to create object with odd value");
}


Even_Num &Even_Num::operator +=(const Even_Num &even_num) {
	val += even_num.val;
	return *this;
}

Even_Num &Even_Num::operator /=(const Even_Num &even_num) {
	if (val / even_num.val % 2 == 1) throw Even_Num_Exception("division results in an odd value");
	val /= even_num.val;
	return *this;
}

int Even_Num::get() const {return val;}
