#include <iostream>

#include "even_num.h"
#include "even_num_exception.h"

using namespace std;

int main() {
	try {
		cout << "Sending 24 to constructor for e1" << endl;
		Even_Num e1 = 24;
		cout << "e1: " << e1 << endl;

		cout << "e1.get(): " << e1.get() << endl;

		try {
			cout << endl;
			cout << "Sending 17 to constructor for e2" << endl;
			Even_Num e2 = 17;
			throw string("No exception thrown on odd value passed to constructor");
		} catch (Even_Num_Exception e) {
			cout << "Exception properly thrown on odd value passed to constructor" << endl;
		}

		cout << endl;
		cout << "Sending 12 to constructor for e3" << endl;
		Even_Num e3 = 12;
		cout << "e3: " << e3 << endl;

		cout << endl;
		cout << "e1 + e3: " << (e1 + e3) << endl;
		cout << "e1 / e3: " << (e1 / e3) << endl;

		cout << endl;
		cout << "e1 += e3: " << (e1 += e3) << endl;
		cout << "e1: " << e1 << endl;
		cout << "e3: " << e3 << endl;

			cout << endl;
		cout << "Resetting e1 to 24" << endl;
		e1 = Even_Num(24);

		cout << "e1 /= e3: " << (e1 /= e3) << endl;
		cout << "e1: " << e1 << endl;
		cout << "e3: " << e3 << endl;


		cout << endl;
		cout << "Sending 20 to constructor for e4" << endl;
		Even_Num e4 = 20;
		cout << "e4: " << e4 << endl;

		cout << endl;
		cout << "Sending 4 to constructor for e5" << endl;
		Even_Num e5 = 4;
		cout << "e5: " << e5 << endl;


		cout << endl;
		try {
			cout << "e4 / e5: " << (e4 / e5) << endl;
			throw string("No exception thrown on odd value produced by /");
		} catch (Even_Num_Exception e) {
			cout << "Exception properly thrown on odd value resulting from /" << endl;
		}

		try {
			cout << "e4 /= e5: " << (e4 /= e5) << endl;
			throw string("No exception thrown on odd value produced by /=");
		} catch (Even_Num_Exception e) {
			cout << "Exception properly thrown on odd value resulting from /=" << endl;
		}

		cout << endl;
		cout << "Invoking default constructor for e6" << endl;
		Even_Num e6;
		cout << "e6: " << e6 << endl;

		cout << "Done" << endl;
		return 0;

	} catch (string e) {
		cout << "*** Exception *** " << e << endl;
		exit(1);
	}
}

