#include <iostream>

#include "pair.h"

using namespace std;

ostream &operator <<(ostream &os, const Pair &pair) {
	os << "(" << *pair.first << "," << *pair.second << ")";
	return os;
}

bool operator ==(const Pair &left, const Pair &right) {
	return *left.first == *right.first && *left.second == *right.second;
}

Pair::Pair(int f, int s) : first(new int(f)), second(new int(s)) {}	

Pair::Pair(const Pair &other) : first(new int(*other.first)), second(new int(*other.second)) {}

Pair::~Pair() {
	delete first;
	delete second;
}

Pair &Pair::operator =(const Pair &rhs) {
	if (this == &rhs) return *this;
	*first = *rhs.first;
	*second = *rhs.second;
	return *this;
}

int Pair::getFirst() const {return *first;}
int Pair::getSecond() const {return *second;}

void Pair::swap() {
	int temp = *first;
	*first = *second;
	*second = temp;
}
