#ifndef PAIR_H
#define PAIR_H

#include <iostream>

class Pair {
	friend std::ostream &operator <<(std::ostream &os, const Pair &pair); 
	friend bool operator ==(const Pair &left, const Pair &right);
public:
	Pair(int f, int s);
	Pair(const Pair &pair);
	~Pair();
	Pair &operator =(const Pair &rhs);
	int getFirst() const;
	int getSecond() const;
	void swap();
private:
	int *first, *second;
};

#endif
