#include <iostream>
#include <string>

#include "pair.h"

using namespace std;

int main() {
	try {
		cout << "Sending 7 and 12 to constructor for p1" << endl;
		Pair  p1(7, 12);
		cout << "p1: " << p1 << endl;

		cout << endl;
		cout << "After calling p1.swap: " << endl;
		p1.swap();
		cout << "p1: " << p1 << endl;

		cout << endl;
		cout << "Initializing p2 with p1 (i.e., using copy constructor)" << endl;
		Pair p2 = p1;
		cout << "p1: " << p1 << endl;
		cout << "p2: " << p1 << endl;
		if (!(p1 == p2)) throw string( "Your copy constructor is not preserving equivalence");

		cout << endl;
		cout << "After calling p2.swap (p1 shoud NOT be changed): " << endl;
		p2.swap();
		cout << "p1: " << p1 << endl;
		cout << "p2: " << p2 << endl;
		if (p1 == p2) throw string("Your copy constructor is not creating an independent object");

		cout << endl;
		cout << "Sending 0 and 0 to constructor for p3" << endl;
		Pair p3(0, 0);
		cout << "p3: " << p3 << endl;

		cout << endl;
		cout << "After assigning p1 tp p3" << endl;
		p3 = p1;
		cout << "p1: " << p1 << endl;
		cout << "p3: " << p1 << endl;
		if (!(p1 == p3)) throw string("Your assignment operator is not preserving equivalence");

		cout << endl;
		cout << "After calling p3.swap (p1 shoud NOT be changed): " << endl;
		p3.swap();
		cout << "p1: " << p1 << endl;
		cout << "p3: " << p3 << endl;
		if (p1 == p3) throw string("Your assignment operator is not creating an independent object");

		cout << "Done" << endl;

		return 0;
	} catch (string s) {
		cout << "*** Exception *** " << s << endl;
		return 1;
	}
}
